#!/usr/bin/env python3

from setuptools import setup

# https://www.sphinx-doc.org/en/master/usage/advanced/setuptools.html
from sphinx.setup_command import BuildDoc
cmdclass = {'build_sphinx': BuildDoc}

setup(name='gems',
    version='0.7',
    description='The GEneral Microspeciation Solver',
    author='Salvador Blasco',
    author_email='salvador.blasco@protonmail.com',
    license='MIT',
    package_dir={'': 'src'},
    packages=['gems'],
    scripts=['src/rungems.py'],
    cmdclass=cmdclass,

    # Specify which Python versions you support. In contrast to the
    # 'Programming Language' classifiers above, 'pip install' will check this
    # and refuse to install the project if the version does not match. See
    # https://packaging.python.org/guides/distributing-packages-using-setuptools/#python-requires
    python_requires='>=3.6, <4',

    package_data={  # Optional
        'doc': ['doc/build/html/*.html'],
    },
    include_package_data=True,

    install_requires=['numpy', 'scipy', 'matplotlib']
)

